import QtQuick 2.12

Item {
    id: keyboard
    readonly property var keysRow0: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '0']
    readonly property var keysRow1: ['q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p']
    readonly property var keysRow2: ['a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l']
    readonly property var keysRow3: ['z', 'x', 'c', 'v', 'b', 'n', 'm',',','.','/']

    property bool shift: false

    signal keyPressed(var key)
    signal backspacePressed()
    signal hidePressed()

    property int keyHeight: (keyboard.height) * 0.2
    property int keyWidth: (keyboard.width) * 0.1

    height:parent.height * 0.5
    width: parent.width


    z:100 // to make sure we're on top of everything

    Column{
        id: keyColumn
        property var rows: [keysRow0, keysRow1, keysRow2, keysRow3]
        Repeater{
            model:keyColumn.rows
            Row{
                anchors.horizontalCenter: parent.horizontalCenter

                Repeater{
                    model:modelData
                    Button {
                        height: keyHeight
                        width: keyWidth
                        text: shift ? String(modelData).toUpperCase() : modelData
                        onClicked: keyPress(modelData)
                    }
                }
            }
        }

        Row{
            anchors.horizontalCenter: parent.horizontalCenter

            Button {
                height: keyHeight
                width: keyWidth
                text: "⇧"
                onClicked: shift = !shift
            }

            Button {
                height: keyHeight
                width: keyWidth * (keysRow3.length - 3)  - 3
                text: "Space"
                onClicked: keyPress(" ")
            }

            Button {
                height: keyHeight
                width: keyWidth
                text: "⌫"
                onClicked: keyPress("⌫")
            }

            Button {
                height: keyHeight
                width: keyWidth
                text: "⌨"
                onClicked: keyPress("⌨")
            }
        }
    }

    function keyPress(key) {
        if (key === "⌫") {
            backspacePressed()
        } else if (key === "⌨") {
            hidePressed()
        } else {
            if (shift) {
                keyPressed(String(key).toUpperCase())
            } else {
                keyPressed(key)
            }
            shift = false
        }
    }
}
